#==============================================================================
# testmsg.m - Test version of a message description file               02/04/92
#==============================================================================

 enum   = TEST_MESSAGES             # Enumerated set identifier
 lookup = LookupTestMsg             # Name of look-up subroutine

#------------------------------------------------------------------------------
# Message labels and strings.  These messages are based on the error codes
# and messages from a C-based token scanner and preprocessor.
#------------------------------------------------------------------------------

 msg TM_OK          = "Successful"
 msg TM_INIT        = "Error during initialization via settoken() and set_pretoken()"

 # Error codes returned by add_keyword() only

 msg TM_TYPE_SMALL  = "Token type too small:  must be > TK_MAX_TYPE"

 # Error codes returned by settoken(), set_pretoken(), and pretoken()

 msg TM_FLEN        = "File name too long"
 msg TM_SLEN        = "Character stream string is too long"
 msg TM_OPEN        = "Error on file open"

 # Error codes returned by both gettoken() and pretoken()

 msg TM_TOOLONG     = "Token is too long (won't fit in token buffer)"
 msg TM_BADTOKEN    = "Unrecognized token"
 msg TM_UNTERM      = "Unterminated string encountered"
 msg TM_COMMENT     = "Comment was not terminated before end-of-stream reached"
 msg TM_BADID       = "Invalid identifier"
 msg TM_BADCONST    = "Invalid numeric constant"

 # Error codes returned by add_keyword() and pretoken()

 msg TM_PPT_ENTRIES = "Preprocessor table full: no more entries available"
 msg TM_PPT_SPACE   = "Preprocessor table full: not enough string space left"
 msg TM_PRE_DEF     = "Identifier/keyword is already defined"

 # Error codes returned only by pretoken()

 msg TM_NEST        = "Too many nested #includes or #defines"
 msg TM_DEF_NOTID   = "Token following #define is not an identifier"
 msg TM_DEF_LONG    = "#define text is too long"
 msg TM_INCL_STRING = "#include is not followed by a string (for the file name)"

#------------------------------------------------------------------------------
# The last message:  If a program tries to get a message with a message id
# greater than this message's id, it will always get this message.
#------------------------------------------------------------------------------

 msg TM_MAX         = "*** Internal error: Message number out-of-range"
